<html lang="ar" dir="rtl">

<head>
    <title>Search</title>



    <style>
        * {
            margin: 0;
            padding: 0;
        }

        body {
            background-color: #f2f2f2;
            font-family: Arial, sans-serif;
        }

        .submit-button {
            padding: 10px 20px;
            background-color: #4CAF50;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .submit-button:hover,
        .submit-button:focus {
            background-color: #45a049;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #e0e0e0;
            background-color: #f9f9f9;
        }

        th,
        td {
            padding: 12px;
            text-align: center;
            border: 1px solid #e0e0e0;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        html,
        body {
            margin: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .container {
            text-align: center;
        }

        .search-form {
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .search-bar {
            padding: 8px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 4px;
            margin-right: 10px;
        }

        .submit-button {
            padding: 8px 16px;
            font-size: 16px;
        }

        .table-container {
            max-height: 300px;
            width: 100%;
            overflow: auto;
            border: 1px solid #e0e0e0;
        }

        .parent {
            margin: 40px;
        }
    </style>

</head>

<body>
    <div class="parent">
        <div class="container">
            <form action="<?php echo e(URL::current()); ?>" method="GET" class="search-form">
                <input name="id_card" type="text" class="search-bar" placeholder="رقم الهوية"
                    value="<?php echo e(request('id_card')); ?>">
                <button type="submit" class="submit-button">Submit</button>
            </form>
            <?php if($data): ?>
                <table dir="rtl" class="table-container">
                    <tr>
                        <th>رقم الهوية</th>
                        <th><?php echo e($data['id_card']); ?> </th>
                    </tr>
                    <tr>
                        <th> الاسم</th>
                        <th><?php echo e($data['name']); ?> </th>
                    </tr>
                    <tr>
                        <th>الجنس </th>
                        <th><?php echo e($data['sex']); ?> </th>
                    </tr>
                    <tr>
                        <th>الحالة الاجتماعية </th>
                        <th><?php echo e($data['marital_status']); ?> </th>
                    </tr>
                    <tr>
                        <th>رد الاحتلال </th>
                        <th><?php echo e($data['occupation_response']); ?> </th>
                    </tr>
                    <tr>
                        <th>قطر فعال </th>
                        <th><?php echo e($data['qatar_active']); ?> </th>
                    </tr>
                    <tr>
                        <th>الرفض </th>
                        <th><?php echo e($data['reject']); ?> </th>
                    </tr>
                    <tr>
                        <th>سبب الرفض </th>
                        <th><?php echo e($data['reject_reason']); ?> </th>
                    </tr>
                    <tr>
                        <th>المصدر </th>
                        <th><?php echo e($data['source']); ?> </th>
                    </tr>
                    <tr>
                        <th>رد المنطقة </th>
                        <th><?php echo e($data['region_reply']); ?> </th>
                    </tr>
                    <tr>
                        <th>رفض بسبب الحالة الاجتماعية </th>
                        <th><?php echo e($data['reject_marital_status']); ?></th>
                    </tr>
                    <tr>
                        <th>رفض بسبب تصريح العمل </th>
                        <th><?php echo e($data['reject_work_permit']); ?></th>
                    </tr>
                    <tr>
                        <th>الاستفادة من الشؤون الاجتماعية </th>
                        <th><?php echo e($data['mossa_benefit']); ?> </th>
                    </tr>
                    <tr>
                        <th>استفادة الزوجة من الشؤون الاجتماعية </th>
                        <th><?php echo e($data['mossa_benefit_wife']); ?> </th>
                    </tr>
                    <tr>
                        <th>حالة الوفاة </th>
                        <th><?php echo e($data['death_status']); ?> </th>
                    </tr>
                    <tr>
                        <th>تاريخ الوفاة </th>
                        <th><?php echo e($data['death_date']); ?> </th>
                    </tr>
                    <tr>
                        <th>حالة الوفاة - وزارة الصحة </th>
                        <th><?php echo e($data['death_moh']); ?> </th>
                    </tr>
                    <tr>
                        <th>تاريخ الوفاة -وزارة الصحة </th>
                        <th><?php echo e($data['death_moh_date']); ?> </th>
                    </tr>
                    <tr>
                        <th>تاريخ السفر </th>
                        <th><?php echo e($data['citizen_place']); ?> </th>
                    </tr>
                    <tr>
                        <th>سبب السفر </th>
                        <th><?php echo e($data['visit_purpose_desc']); ?> </th>
                    </tr>
                    <tr>
                        <th>المعبر </th>
                        <th><?php echo e($data['cross_desc']); ?> </th>
                    </tr>
                    <tr>
                        <th>العاملين </th>
                        <th><?php echo e($data['worker']); ?> </th>
                    </tr>
                    <tr>
                        <th>موظف حكومي </th>
                        <th><?php echo e($data['government_employees']); ?> </th>
                    </tr>
                    <tr>
                        <th>التأمين الصحي </th>
                        <th><?php echo e($data['health_insurance']); ?> </th>
                    </tr>
                    <tr>
                        <th> هوية الزوجة</th>
                        <th><?php echo e($data['id_card_wife']); ?> </th>
                    </tr>

                </table>
            <?php endif; ?>
        </div>
    </div>


</body>

</html>


</div>
</div>
</div>
</div>
</div>
<?php /**PATH C:\Users\alsho\Desktop\search\resources\views/search.blade.php ENDPATH**/ ?>